/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.common.Ref8U;
import org.apache.poi.util.LittleEndianOutput;

public final class FeatRecord
extends StandardRecord {
    public static final short sid = 2152;
    private int isf_sharedFeatureType;
    private byte reserved1;
    private long reserved2;
    private int cref;
    private long cbFeatData;
    private int reserved3;
    private Ref8U[] cellRefs;
    private byte[] rgbFeat;

    public FeatRecord() {
    }

    public short getSid() {
        return 2152;
    }

    public FeatRecord(RecordInputStream in) {
        this.isf_sharedFeatureType = in.readShort();
        this.reserved1 = in.readByte();
        this.reserved2 = in.readLong();
        this.cref = in.readUShort();
        this.cbFeatData = in.readLong();
        this.reserved3 = in.readShort();
        this.cellRefs = new Ref8U[this.cref];
        for (int i2 = 0; i2 < this.cellRefs.length; ++i2) {
            this.cellRefs[i2] = new Ref8U(in);
        }
        this.rgbFeat = in.readRemainder();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SHARDED FEATURE]\n");
        buffer.append("[/SHARED FEATURE]\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.isf_sharedFeatureType);
    }

    protected int getDataSize() {
        return -1;
    }
}

