/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherShapePathProperty;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hssf.model.AbstractShape;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.EndSubRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.usermodel.HSSFPolygon;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.util.LittleEndian;

public class PolygonShape
extends AbstractShape {
    public static final short OBJECT_TYPE_MICROSOFT_OFFICE_DRAWING = 30;
    private EscherContainerRecord spContainer;
    private ObjRecord objRecord;

    PolygonShape(HSSFPolygon hssfShape, int shapeId) {
        this.spContainer = this.createSpContainer(hssfShape, shapeId);
        this.objRecord = this.createObjRecord(hssfShape, shapeId);
    }

    private EscherContainerRecord createSpContainer(HSSFPolygon hssfShape, int shapeId) {
        byte[] data;
        HSSFPolygon shape = hssfShape;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        sp.setRecordId((short)-4086);
        sp.setOptions((short)370);
        sp.setShapeId(shapeId);
        if (hssfShape.getParent() == null) {
            sp.setFlags(2560);
        } else {
            sp.setFlags(2562);
        }
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherSimpleProperty(4, false, false, 0));
        opt.addEscherProperty(new EscherSimpleProperty(322, false, false, hssfShape.getDrawAreaWidth()));
        opt.addEscherProperty(new EscherSimpleProperty(323, false, false, hssfShape.getDrawAreaHeight()));
        opt.addEscherProperty(new EscherShapePathProperty(324, 4));
        EscherArrayProperty verticesProp = new EscherArrayProperty(325, false, new byte[0]);
        verticesProp.setNumberOfElementsInArray(hssfShape.getXPoints().length + 1);
        verticesProp.setNumberOfElementsInMemory(hssfShape.getXPoints().length + 1);
        verticesProp.setSizeOfElements(65520);
        for (int i2 = 0; i2 < hssfShape.getXPoints().length; ++i2) {
            data = new byte[4];
            LittleEndian.putShort(data, 0, (short)hssfShape.getXPoints()[i2]);
            LittleEndian.putShort(data, 2, (short)hssfShape.getYPoints()[i2]);
            verticesProp.setElement(i2, data);
        }
        int point = hssfShape.getXPoints().length;
        data = new byte[4];
        LittleEndian.putShort(data, 0, (short)hssfShape.getXPoints()[0]);
        LittleEndian.putShort(data, 2, (short)hssfShape.getYPoints()[0]);
        verticesProp.setElement(point, data);
        opt.addEscherProperty(verticesProp);
        EscherArrayProperty segmentsProp = new EscherArrayProperty(326, false, null);
        segmentsProp.setSizeOfElements(2);
        segmentsProp.setNumberOfElementsInArray(hssfShape.getXPoints().length * 2 + 4);
        segmentsProp.setNumberOfElementsInMemory(hssfShape.getXPoints().length * 2 + 4);
        segmentsProp.setElement(0, new byte[]{0, 64});
        segmentsProp.setElement(1, new byte[]{0, -84});
        for (int i3 = 0; i3 < hssfShape.getXPoints().length; ++i3) {
            segmentsProp.setElement(2 + i3 * 2, new byte[]{1, 0});
            segmentsProp.setElement(3 + i3 * 2, new byte[]{0, -84});
        }
        segmentsProp.setElement(segmentsProp.getNumberOfElementsInArray() - 2, new byte[]{1, 96});
        segmentsProp.setElement(segmentsProp.getNumberOfElementsInArray() - 1, new byte[]{0, -128});
        opt.addEscherProperty(segmentsProp);
        opt.addEscherProperty(new EscherSimpleProperty(383, false, false, 65537));
        opt.addEscherProperty(new EscherSimpleProperty(464, false, false, 0));
        opt.addEscherProperty(new EscherSimpleProperty(465, false, false, 0));
        opt.addEscherProperty(new EscherSimpleProperty(471, false, false, 0));
        this.addStandardOptions(shape, opt);
        EscherRecord anchor = this.createAnchor(shape.getAnchor());
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        return spContainer;
    }

    private ObjRecord createObjRecord(HSSFShape hssfShape, int shapeId) {
        HSSFShape shape = hssfShape;
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord c2 = new CommonObjectDataSubRecord();
        c2.setObjectType((short)30);
        c2.setObjectId(shapeId);
        c2.setLocked(true);
        c2.setPrintable(true);
        c2.setAutofill(true);
        c2.setAutoline(true);
        EndSubRecord e2 = new EndSubRecord();
        obj.addSubRecord(c2);
        obj.addSubRecord(e2);
        return obj;
    }

    public EscherContainerRecord getSpContainer() {
        return this.spContainer;
    }

    public ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

