/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.IllegalPropertySetDataException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.UnsupportedVariantTypeException;
import org.apache.poi.hpsf.VariantSupport;
import org.apache.poi.util.LittleEndian;

public class TypeWriter {
    public static int writeToStream(OutputStream out, short n2) throws IOException {
        int length = 2;
        byte[] buffer = new byte[2];
        LittleEndian.putShort(buffer, 0, n2);
        out.write(buffer, 0, 2);
        return 2;
    }

    public static int writeToStream(OutputStream out, int n2) throws IOException {
        int l2 = 4;
        byte[] buffer = new byte[4];
        LittleEndian.putInt(buffer, 0, n2);
        out.write(buffer, 0, 4);
        return 4;
    }

    public static int writeToStream(OutputStream out, long n2) throws IOException {
        int l2 = 8;
        byte[] buffer = new byte[8];
        LittleEndian.putLong(buffer, 0, n2);
        out.write(buffer, 0, 8);
        return 8;
    }

    public static void writeUShortToStream(OutputStream out, int n2) throws IOException {
        int high = n2 & 0xFFFF0000;
        if (high != 0) {
            throw new IllegalPropertySetDataException("Value " + n2 + " cannot be represented by 2 bytes.");
        }
        TypeWriter.writeToStream(out, (short)n2);
    }

    public static int writeUIntToStream(OutputStream out, long n2) throws IOException {
        long high = n2 & 0xFFFFFFFF00000000L;
        if (high != 0L && high != -4294967296L) {
            throw new IllegalPropertySetDataException("Value " + n2 + " cannot be represented by 4 bytes.");
        }
        return TypeWriter.writeToStream(out, (int)n2);
    }

    public static int writeToStream(OutputStream out, ClassID n2) throws IOException {
        byte[] b2 = new byte[16];
        n2.write(b2, 0);
        out.write(b2, 0, b2.length);
        return b2.length;
    }

    public static void writeToStream(OutputStream out, Property[] properties, int codepage) throws IOException, UnsupportedVariantTypeException {
        Property p2;
        int i2;
        if (properties == null) {
            return;
        }
        for (i2 = 0; i2 < properties.length; ++i2) {
            p2 = properties[i2];
            TypeWriter.writeUIntToStream(out, p2.getID());
            TypeWriter.writeUIntToStream(out, p2.getSize());
        }
        for (i2 = 0; i2 < properties.length; ++i2) {
            p2 = properties[i2];
            long type = p2.getType();
            TypeWriter.writeUIntToStream(out, type);
            VariantSupport.write(out, (int)type, p2.getValue(), codepage);
        }
    }

    public static int writeToStream(OutputStream out, double n2) throws IOException {
        int l2 = 8;
        byte[] buffer = new byte[8];
        LittleEndian.putDouble(buffer, 0, n2);
        out.write(buffer, 0, 8);
        return 8;
    }
}

