/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.UnsupportedVariantTypeException;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.VariantSupport;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class Property {
    protected long id;
    protected long type;
    protected Object value;

    public long getID() {
        return this.id;
    }

    public long getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Property(long id, long type, Object value) {
        this.id = id;
        this.type = type;
        this.value = value;
    }

    public Property(long id, byte[] src, long offset, int length, int codepage) throws UnsupportedEncodingException {
        this.id = id;
        if (id == 0L) {
            this.value = this.readDictionary(src, offset, length, codepage);
            return;
        }
        int o2 = (int)offset;
        this.type = LittleEndian.getUInt(src, o2);
        o2 += 4;
        try {
            this.value = VariantSupport.read(src, o2, length, (int)this.type, codepage);
        }
        catch (UnsupportedVariantTypeException ex) {
            VariantSupport.writeUnsupportedTypeMessage(ex);
            this.value = ex.getValue();
        }
    }

    protected Property() {
    }

    protected Map readDictionary(byte[] src, long offset, int length, int codepage) throws UnsupportedEncodingException {
        if (offset < 0L || offset > (long)src.length) {
            throw new HPSFRuntimeException("Illegal offset " + offset + " while HPSF stream contains " + length + " bytes.");
        }
        int o2 = (int)offset;
        long nrEntries = LittleEndian.getUInt(src, o2);
        o2 += 4;
        HashMap<Long, String> m2 = new HashMap<Long, String>((int)nrEntries, 1.0f);
        try {
            int i2 = 0;
            while ((long)i2 < nrEntries) {
                Long id = LittleEndian.getUInt(src, o2);
                long sLength = LittleEndian.getUInt(src, o2 += 4);
                o2 += 4;
                StringBuffer b2 = new StringBuffer();
                switch (codepage) {
                    case -1: {
                        b2.append(new String(src, o2, (int)sLength));
                        break;
                    }
                    case 1200: {
                        int nrBytes = (int)(sLength * 2L);
                        byte[] h2 = new byte[nrBytes];
                        for (int i22 = 0; i22 < nrBytes; i22 += 2) {
                            h2[i22] = src[o2 + i22 + 1];
                            h2[i22 + 1] = src[o2 + i22];
                        }
                        b2.append(new String(h2, 0, nrBytes, VariantSupport.codepageToEncoding(codepage)));
                        break;
                    }
                    default: {
                        b2.append(new String(src, o2, (int)sLength, VariantSupport.codepageToEncoding(codepage)));
                    }
                }
                while (b2.length() > 0 && b2.charAt(b2.length() - 1) == '\u0000') {
                    b2.setLength(b2.length() - 1);
                }
                if (codepage == 1200) {
                    if (sLength % 2L == 1L) {
                        ++sLength;
                    }
                    o2 = (int)((long)o2 + (sLength + sLength));
                } else {
                    o2 = (int)((long)o2 + sLength);
                }
                m2.put(id, b2.toString());
                ++i2;
            }
        }
        catch (RuntimeException ex) {
            POILogger l2 = POILogFactory.getLogger(this.getClass());
            l2.log(POILogger.WARN, (Object)("The property set's dictionary contains bogus data. All dictionary entries starting with the one with ID " + this.id + " will be ignored."), ex);
        }
        return m2;
    }

    protected int getSize() throws WritingNotSupportedException {
        int length = VariantSupport.getVariantLength(this.type);
        if (length >= 0) {
            return length;
        }
        if (length == -2) {
            throw new WritingNotSupportedException(this.type, null);
        }
        int PADDING = 4;
        switch ((int)this.type) {
            case 30: {
                int l2 = ((String)this.value).length() + 1;
                int r2 = l2 % 4;
                if (r2 > 0) {
                    l2 += 4 - r2;
                }
                length += l2;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new WritingNotSupportedException(this.type, this.value);
            }
        }
        return length;
    }

    public boolean equals(Object o2) {
        Class<?> pValueClass;
        if (!(o2 instanceof Property)) {
            return false;
        }
        Property p2 = (Property)o2;
        Object pValue = p2.getValue();
        long pId = p2.getID();
        if (this.id != pId || this.id != 0L && !this.typesAreEqual(this.type, p2.getType())) {
            return false;
        }
        if (this.value == null && pValue == null) {
            return true;
        }
        if (this.value == null || pValue == null) {
            return false;
        }
        Class<?> valueClass = this.value.getClass();
        if (!valueClass.isAssignableFrom(pValueClass = pValue.getClass()) && !pValueClass.isAssignableFrom(valueClass)) {
            return false;
        }
        if (this.value instanceof byte[]) {
            return Util.equal((byte[])this.value, (byte[])pValue);
        }
        return this.value.equals(pValue);
    }

    private boolean typesAreEqual(long t1, long t2) {
        return t1 == t2 || t1 == 30L && t2 == 31L || t2 == 30L && t1 == 31L;
    }

    public int hashCode() {
        long hashCode = 0L;
        hashCode += this.id;
        hashCode += this.type;
        if (this.value != null) {
            hashCode += (long)this.value.hashCode();
        }
        int returnHashCode = (int)(hashCode & 0xFFFFFFFFL);
        return returnHashCode;
    }

    public String toString() {
        StringBuffer b2 = new StringBuffer();
        b2.append(this.getClass().getName());
        b2.append('[');
        b2.append("id: ");
        b2.append(this.getID());
        b2.append(", type: ");
        b2.append(this.getType());
        Object value = this.getValue();
        b2.append(", value: ");
        b2.append(value.toString());
        if (value instanceof String) {
            String s2 = (String)value;
            int l2 = s2.length();
            byte[] bytes = new byte[l2 * 2];
            for (int i2 = 0; i2 < l2; ++i2) {
                char c2 = s2.charAt(i2);
                byte high = (byte)((c2 & 0xFF00) >> 8);
                byte low = (byte)((c2 & 0xFF) >> 0);
                bytes[i2 * 2] = high;
                bytes[i2 * 2 + 1] = low;
            }
            String hex = HexDump.dump(bytes, 0L, 0);
            b2.append(" [");
            b2.append(hex);
            b2.append("]");
        }
        b2.append(']');
        return b2.toString();
    }
}

