/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.MutableProperty;

public class CustomProperties
extends HashMap {
    private Map dictionaryIDToName = new HashMap();
    private Map dictionaryNameToID = new HashMap();
    private boolean isPure = true;

    public Object put(Object name, Object customProperty) throws ClassCastException {
        CustomProperty cp = (CustomProperty)customProperty;
        if (name == null) {
            this.isPure = false;
            return null;
        }
        if (!(name instanceof String)) {
            throw new ClassCastException("The name of a custom property must be a java.lang.String, but it is a " + name.getClass().getName());
        }
        if (!name.equals(cp.getName())) {
            throw new IllegalArgumentException("Parameter \"name\" (" + name + ") and custom property's name (" + cp.getName() + ") do not match.");
        }
        Long idKey = cp.getID();
        Object oldID = this.dictionaryNameToID.get(name);
        this.dictionaryIDToName.remove(oldID);
        this.dictionaryNameToID.put(name, idKey);
        this.dictionaryIDToName.put(idKey, name);
        Object oldCp = super.remove(oldID);
        super.put(idKey, cp);
        return oldCp;
    }

    private Object put(CustomProperty customProperty) throws ClassCastException {
        String name = customProperty.getName();
        Long oldId = (Long)this.dictionaryNameToID.get(name);
        if (oldId != null) {
            customProperty.setID(oldId);
        } else {
            long max = 1L;
            Iterator i2 = this.dictionaryIDToName.keySet().iterator();
            while (i2.hasNext()) {
                long id = (Long)i2.next();
                if (id <= max) continue;
                max = id;
            }
            customProperty.setID(max + 1L);
        }
        return this.put((Object)name, customProperty);
    }

    public Object remove(String name) {
        Long id = (Long)this.dictionaryNameToID.get(name);
        if (id == null) {
            return null;
        }
        this.dictionaryIDToName.remove(id);
        this.dictionaryNameToID.remove(name);
        return super.remove(id);
    }

    public Object put(String name, String value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(31L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    public Object put(String name, Long value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(20L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    public Object put(String name, Double value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(5L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    public Object put(String name, Integer value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(3L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    public Object put(String name, Boolean value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(11L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    public Object get(String name) {
        Long id = (Long)this.dictionaryNameToID.get(name);
        CustomProperty cp = (CustomProperty)super.get(id);
        return cp != null ? cp.getValue() : null;
    }

    public Object put(String name, Date value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(64L);
        p2.setValue(value);
        CustomProperty cp = new CustomProperty(p2, name);
        return this.put(cp);
    }

    public Set keySet() {
        return this.dictionaryNameToID.keySet();
    }

    public void setCodepage(int codepage) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(1L);
        p2.setType(2L);
        p2.setValue(codepage);
        this.put(new CustomProperty(p2));
    }

    Map getDictionary() {
        return this.dictionaryIDToName;
    }

    public int getCodepage() {
        int codepage = -1;
        Iterator i2 = this.values().iterator();
        while (codepage == -1 && i2.hasNext()) {
            CustomProperty cp = (CustomProperty)i2.next();
            if (cp.getID() != 1L) continue;
            codepage = (Integer)cp.getValue();
        }
        return codepage;
    }

    public boolean isPure() {
        return this.isPure;
    }

    public void setPure(boolean isPure) {
        this.isPure = isPure;
    }
}

