/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;

public class DefaultComponentManager
implements ComponentManager {
    private final HashMap m_components = new HashMap();
    private final ComponentManager m_parent;
    private boolean m_readOnly;

    public DefaultComponentManager() {
        this(null);
    }

    public DefaultComponentManager(ComponentManager parent) {
        this.m_parent = parent;
    }

    public Component lookup(String role) throws ComponentException {
        Component component = (Component)this.m_components.get(role);
        if (null != component) {
            return component;
        }
        if (null != this.m_parent) {
            return this.m_parent.lookup(role);
        }
        throw new ComponentException(role, "Unable to provide implementation.");
    }

    public boolean hasComponent(String role) {
        boolean componentExists = false;
        try {
            this.release(this.lookup(role));
            componentExists = true;
        }
        catch (Throwable t2) {}
        return componentExists;
    }

    public void put(String role, Component component) {
        this.checkWriteable();
        this.m_components.put(role, component);
    }

    public void release(Component component) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator components = this.m_components.keySet().iterator();
        buffer.append("Components:");
        while (components.hasNext()) {
            buffer.append("[");
            buffer.append(components.next());
            buffer.append("]");
        }
        return buffer.toString();
    }

    protected final ComponentManager getParent() {
        return this.m_parent;
    }

    protected final Map getComponentMap() {
        return this.m_components;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("ComponentManager is read only and can not be modified");
        }
    }
}

