/*
 * Decompiled with CFR 0.152.
 */
package mymdbce.kodi.dto;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mymdbce.kodi.KodiUtilities;
import mymdbce.kodi.dto.Actor;
import mymdbce.kodi.dto.Audio;
import mymdbce.kodi.dto.Fanart;
import mymdbce.kodi.dto.Fileinfo;
import mymdbce.kodi.dto.KodiSet;
import mymdbce.kodi.dto.Ratings;
import mymdbce.kodi.dto.Streamdetails;
import mymdbce.kodi.dto.Subtitle;
import mymdbce.kodi.dto.Thumb;
import mymdbce.kodi.dto.UniqueId;
import mymdbce.kodi.dto.Video;

@JacksonXmlRootElement(localName="movie")
public class KodiMovie {
    public String title;
    public String originaltitle;
    public Ratings ratings;
    public String userrating = "0";
    public String top250 = "0";
    public String outline = "";
    public String plot = "";
    public String tagline = "";
    public String runtime = "";
    public String mpaa = "";
    public int playcount = 0;
    public String lastplayed = "";
    public String id = "";
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<Thumb> thumb = new ArrayList<Thumb>();
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<UniqueId> uniqueid;
    public Fanart fanart = new Fanart();
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<String> genre;
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<String> country;
    @JacksonXmlProperty(localName="set")
    public KodiSet kodiSet;
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<String> credits;
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<String> director;
    public String premiered;
    public String year;
    public String status;
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<String> tag;
    public String code;
    public String aired;
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<String> studio;
    public String trailer;
    public Fileinfo fileinfo;
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<Actor> actor;

    public KodiMovie(HashMap<String, String> hashMap) {
        KodiUtilities kodiUtilities = new KodiUtilities();
        this.title = kodiUtilities.getValueWithDefault(hashMap, "titel");
        this.originaltitle = kodiUtilities.getValueWithDefault(hashMap, "originaltitel");
        this.ratings = kodiUtilities.generateRatings(hashMap);
        this.userrating = kodiUtilities.getValueWithDefault(hashMap, "selfnote", 0);
        this.top250 = kodiUtilities.getValueWithDefault(hashMap, "imdbplatz", 0);
        this.plot = kodiUtilities.getValueWithDefault(hashMap, "inhalt");
        this.runtime = kodiUtilities.getValueWithDefault(hashMap, "laenge", 0);
        this.mpaa = kodiUtilities.getValueWithDefault(hashMap, "fsk");
        this.uniqueid = kodiUtilities.generateUniqueIds(hashMap);
        this.genre = kodiUtilities.trimType(hashMap.get("genre"));
        this.country = kodiUtilities.trimType(hashMap.get("herstellungsland"));
        this.outline = kodiUtilities.getValueWithDefault(hashMap, hashMap.get("inhalt"));
        this.director = kodiUtilities.trimType(hashMap.get("regie"));
        this.actor = kodiUtilities.trimActors(hashMap.get("darsteller"));
        this.playcount = hashMap.get("gesehen") == "gesehen" ? 1 : 0;
        this.year = hashMap.get("erscheinungsjahr");
        ArrayList<Subtitle> arrayList = new ArrayList<Subtitle>();
        int n2 = Integer.parseInt(!hashMap.get("textcount").equals("") ? hashMap.get("textcount") : "0");
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(new Subtitle("-?-"));
        }
        ArrayList<Audio> arrayList2 = new ArrayList<Audio>();
        n2 = Integer.parseInt(!hashMap.get("audiocount").equals("") ? hashMap.get("audiocount") : "0");
        for (int i3 = 0; i3 < n2; ++i3) {
            arrayList2.add(new Audio(hashMap.get("audiocodec"), "-?-", hashMap.get(hashMap.get("audiokanalmodus"))));
        }
        Video video = new Video(hashMap.get("videocodec"), hashMap.get("videoaspect"), hashMap.get("videobreite"), hashMap.get("videohoehe"), hashMap.get("videolaenge"), "");
        this.fileinfo = new Fileinfo(new Streamdetails(video, arrayList2, arrayList));
        this.tag = kodiUtilities.trimType(hashMap.get("filter"));
    }
}

